<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->string('reg_no');
            $table->string('class');
            $table->string('term');
            $table->string('session');
            $table->string('type');
            $table->integer("discount")->nullable();
            $table->bigInteger("totalbills")->nullable();
            $table->bigInteger("payableamount")->nullable();
            $table->bigInteger("amountpaid")->nullable();
            $table->bigInteger("credit")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
