<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\BillController;
use App\Http\Controllers\DefaultersController;
use App\Http\Controllers\PayrollController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\BankController;
use App\Http\Controllers\OptionController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})
// ->middleware(['auth', 'verified'])
->name('dashboard');

Route::prefix("bills")->group(function() {
    Route::get("/", [BillController::class, 'index'])->name("bills");
    Route::get("/type-of-bill", [BillController::class, 'select_bill_type'])->name("select-bill-type");
    // School Fees Routes Start
    Route::post("/school-fees/create-bill", [BillController::class, 'schoolfees_create'])->name('school-fees-create');
    Route::post("/school-fees/update-bill", [BillController::class, 'schoolfees_update'])->name('school-fees-update');
    Route::post("/school-fees/update-bill/single", [BillController::class, 'schoolfees_update_single'])->name('school-fees-update-single');
    Route::get("/school-fees/check-session-term-bills", [BillController::class, 'schoolfees_query'])->name('school-fees-query');
    // School fees routes end

    // Practical route start
    Route::post("/practicals/create-and-update", [BillController::class, 'practicals_create_update'])->name('practicals-create-update');

});

Route::prefix("defaulters")->group(function() {
    Route::get("/", [DefaultersController::class, 'index'])->name("defaulters");
    Route::get("/cleared-students", [DefaultersController::class, 'clearedIndex'])->name("cleared-students");
    Route::get("/defaulting-students", [DefaultersController::class, 'defaultingIndex'])->name("defaulting-students");
    Route::post("/change-status", [DefaultersController::class, 'changeStatus'])->name("change-defaulters-status");
});

Route::prefix("payroll")->group(function() {
    Route::get("/", [PayrollController::class, 'index'])->name("payroll");
});

Route::prefix("payments-analysis")->group(function() {
    Route::get("/", [PaymentController::class, 'index'])->name("payments");
    Route::get("/select-payments", [PaymentController::class, 'select'])->name("select-payments");
});


Route::prefix("bank-transfer")->group(function() {
    Route::get("/", [BankController::class, 'index'])->name("bank-transfer");
});

Route::prefix("options")->group(function() {
    Route::get("/", [OptionController::class, 'index'])->name("options");
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::prefix("subject-registration")->middleware(['auth','verified'])->group(function() {
    Route::get("/confirm-student-department", [SubjectRegistrationController::class, 'confirm'])->name("confirm-dept");
});

require __DIR__.'/auth.php';
